import {
    ItemStack,
    world
} from "@minecraft/server"
world.afterEvents.playerJoin.subscribe(event => {
    const playerId= event.playerId
    const player = world.getEntity(playerId)
    player.getComponent("inventory").container.addItem(new ItemStack("minecraft:stick"))
})
world.afterEvents.itemUse.subscribe(event => {
    const item = event.itemStack
    const player = event.source
    if (item.typeId == "minecraft:stick") {
        try {
            player.dimension.spawnEntity("minecraft:evocation_fang", player.location)
        } catch (e) {
            world.sendMessage("Tried to spawn evocation fang but got the error:\n" + e)
        }
    }
})